% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_ppv.R
\name{ppv}
\alias{ppv}
\alias{precision}
\title{Positive Predictive Value}
\usage{
ppv(truth, response, positive, na_value = NaN, ...)

precision(truth, response, positive, na_value = NaN, ...)
}
\arguments{
\item{truth}{:: \code{factor()}\cr
True (observed) labels.
Must have exactly same two levels and the same length as \code{response}.}

\item{response}{:: \code{factor()}\cr
Predicted response labels.
Must have exactly same two levels and the same length as \code{truth}.}

\item{positive}{:: \code{character(1)}\cr
Name of the positive class.}

\item{na_value}{:: \code{numeric(1)}\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Binary classification measure defined as \deqn{
   \frac{\mathrm{TP}}{\mathrm{TP} + \mathrm{FP}}.
}{
   TP / (TP + FP).
}
Also know as "precision".
}
\note{
This measure is undefined if TP + FP = 0.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"binary"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
ppv(truth, response, positive = "a")
}
\references{
\url{https://en.wikipedia.org/wiki/Template:DiagnosticTesting_Diagram}
}
\seealso{
Other Binary Classification Measures: \code{\link{auc}},
  \code{\link{dor}}, \code{\link{fbeta}},
  \code{\link{fdr}}, \code{\link{fnr}}, \code{\link{fn}},
  \code{\link{fomr}}, \code{\link{fpr}}, \code{\link{fp}},
  \code{\link{mcc}}, \code{\link{npv}}, \code{\link{tnr}},
  \code{\link{tn}}, \code{\link{tpr}}, \code{\link{tp}}
}
\concept{Binary Classification Measures}
\concept{binary_classification_measure}
