% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{mlr3oml-package}
\alias{mlr3oml}
\alias{mlr3oml-package}
\title{mlr3oml: Connector Between 'mlr3' and 'OpenML'}
\description{
Provides an interface to 'OpenML.org' to list and
    download machine learning data and tasks. Data and tasks can be
    automatically converted to 'mlr3' tasks. For a more sophisticated
    interface which also allows uploading experiments, see the 'OpenML'
    package.
}
\section{mlr3 Integration}{

This package adds the \link[mlr3:Task]{mlr3::Task} \code{"oml"} and the \link[mlr3:Resampling]{mlr3::Resampling} \code{"oml"} to
\link[mlr3:mlr_tasks]{mlr3::mlr_tasks} and \link[mlr3:mlr_resamplings]{mlr3::mlr_resamplings}, respectively.
For the former you may pass either a \code{data_id} or a \code{task_id}, the latter requires
a \code{task_id}.
}

\section{Options}{

\itemize{
\item \code{mlr3oml.cache}: Enables or disables caching globally.
If set to \code{FALSE}, caching is disabled.
If set to \code{TRUE}, cache directory as reported by \code{\link[=R_user_dir]{R_user_dir()}} is used.
Alternatively, you can specify a path on the local file system here.
Default is \code{FALSE}.
\item \code{mlr3oml.api_key}: API key to use. All operations supported by this package
work without an API key, but you might get rate limited without an API key.
If not set, defaults to the value of the environment variable \code{OPENMLAPIKEY}.
\item \code{mlr3oml.arff_parser}: ARFF parser to use, defaults to the internal one relies
on \code{\link[data.table:fread]{data.table::fread()}}. Can also be set to \code{"RWeka"} for the parser in
\CRANpkg{RWeka} or \code{"farff"} for the reader implemented in \CRANpkg{farff}.
}
}

\section{Logging}{

The \CRANpkg{lgr} package is used for logging.
To change the threshold, use \code{lgr::get_logger("mlr3oml")$set_threshold()}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://mlr3oml.mlr-org.com}
  \item \url{https://github.com/mlr-org/mlr3oml}
  \item Report bugs at \url{https://github.com/mlr-org/mlr3oml}
}

}
\author{
\strong{Maintainer}: Michel Lang \email{michellang@gmail.com} (\href{https://orcid.org/0000-0001-9754-0393}{ORCID})

}
