#' @importFrom utils bibentry
bibentries = c(
  barber_2021 = bibentry("article",
    doi       = "10.1214/20-AOS1965",
    year      = "2021",
    month     = "02",
    volume    = "49",
    pages     = "486--507",
    author    = "Rina Foygel Barber and Emmanuel J. Candes and Aaditya Ramdasa and Ryan J. Tibshirani",
    title     = "Predictive inference with the jackknife+",
    journal   = "Annals of Statistics"
  ),

  chawla_2002 = bibentry("article",
    doi       = "10.1613/jair.953",
    year      = "2002",
    month     = "jun",
    publisher = "{AI} Access Foundation",
    volume    = "16",
    pages     = "321--357",
    author    = "N. V. Chawla and K. W. Bowyer and L. O. Hall and W. P. Kegelmeyer",
    title     = "{SMOTE}: Synthetic Minority Over-sampling Technique",
    journal   = "Journal of Artificial Intelligence Research"
  ),

  ding_2010   = bibentry("article",
    author    = "Yufeng Ding and Jeffrey S. Simonoff",
    title     = "An Investigation of Missing Data Methods for Classification Trees Applied to Binary Response Data",
    journal   = "Journal of Machine Learning Research",
    year      = "2010",
    volume    = "11",
    number    = "6",
    pages     = "131-170",
    url       = "https://jmlr.org/papers/v11/ding10a.html"
  ),

  ledell_2015 = bibentry("phdthesis",
    title     = "Scalable Ensemble Learning and Computationally Efficient Variance Estimation",
    author    = "LeDell, Erin",
    year      = "2015",
    school    = "UC Berkeley"
  ),

  thomas2017  = bibentry("article",
    doi       = "10.1155/2017/1421409",
    year      = "2017",
    publisher = "Hindawi Limited",
    volume    = "2017",
    pages     = "1--8",
    author    = "Janek Thomas and Tobias Hepp and Andreas Mayr and Bernd Bischl",
    title     = "Probing for Sparse and Fast Variable Selection with Model-Based Boosting",
    journal   = "Computational and Mathematical Methods in Medicine"
  ),

  wu2007      = bibentry("article",
    doi       = "10.1198/016214506000000843",
    year      = "2007",
    month     = "3",
    publisher = "Informa {UK} Limited",
    volume    = "102",
    number    = "477",
    pages     = "235--243",
    author    = "Yujun Wu and Dennis D Boos and Leonard A Stefanski",
    title     = "Controlling Variable Selection by the Addition of Pseudovariables",
    journal   = "Journal of the American Statistical Association"
  ),

  zhang2003   = bibentry("inproceedings",
    year      = "2003",
    author    = "Zhang, J. and Mani, I.",
    title     = "KNN Approach to Unbalanced Data Distributions: A Case Study Involving Information Extraction",
    booktitle = "Proceedings of Workshop on Learning from Imbalanced Datasets (ICML)",
  ),

  tomek1976   = bibentry("article",
    doi       = "10.1109/TSMC.1976.4309452",
    author    = "I. Tomek",
    year      = "1976",
    title     = "Two Modifications of CNN",
    journal   = "IEEE Transactions on Systems, Man and Cybernetics",
    volume    = "6",
    number    = "11",
    pages     = "769--772",
    publisher = "IEEE"
  ),

  he_2008     = bibentry("InProceedings",
    author    = "Haibo He and Yang Bai and Garcia, Edwardo A. and Shutao Li",
    booktitle = "2008 IEEE International Joint Conference on Neural Networks (IEEE World Congress on Computational Intelligence)",
    title     = "ADASYN: Adaptive synthetic sampling approach for imbalanced learning",
    year      = "2008",
    pages     = "1322-1328",
    doi       = "10.1109/IJCNN.2008.4633969"
  ),

  han_2005    = bibentry("InProceedings",
    doi       = "10.1007/11538059_91",
    author    = "Hui Han and Wen-Yuan Wang and Bing-Huan Mao",
    editor    = "De-Shuang Huang and Xiao-Ping Zhang and Guang-Bin Huang",
    title     = "Borderline-SMOTE: A New Over-Sampling Method in Imbalanced Data Sets Learning",
    booktitle = "Advances in Intelligent Computing",
    year      = "2005",
    publisher = "Springer Berlin Heidelberg",
    address   = "Berlin, Heidelberg",
    pages     = "878--887",
    isbn      = "978-3-540-31902-3"
  ),

  freeman_1979 = bibentry("InCollection",
    doi        = "10.1016/B978-0-12-636250-3.50015-5",
    author     = "A Myrick Freeman III",
    title      = "The Hedonic Price Approach to Measuring Demand for Neighborhood Characteristics",
    booktitle  = "The Economics of Neighborhood",
    year       = "1979",
    publisher  = "Elsevier",
    pages      = "191--217"
  ),


  gorishniy_2022 = bibentry("InProceedings",
    title        = "On Embeddings for Numerical Features in Tabular Deep Learning",
    volume       = "35",
    url          = "https://proceedings.neurips.cc/paper_files/paper/2022/hash/9e9f0ffc3d836836ca96cbf8fe14b105-Abstract-Conference.html",
    booktitle    = "Advances in Neural Information Processing Systems",
    author       = "Yury Gorishniy and Ivan Rubachev and Artem Babenko",
    year         = "2022",
    pages        = "24991--25004"
  )

)
