% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvDCalibration.R
\name{mlr_measures_surv.dcalib}
\alias{mlr_measures_surv.dcalib}
\alias{MeasureSurvDCalibration}
\title{D-Calibration Survival Measure}
\description{
This calibration method is defined by calculating
\deqn{s = B/n \sum_i (P_i - n/B)^2}
where \eqn{B} is number of 'buckets', \eqn{n} is the number of predictions,
and \eqn{P_i} is the predicted number of deaths in the \eqn{i}th interval
[0, 100/B), [100/B, 50/B),....,[(B - 100)/B, 1).

A model is well-calibrated if \code{s ~ Unif(B)}, tested with \code{chisq.test}
(\code{p > 0.05} if well-calibrated).
Model \code{i} is better calibrated than model \code{j} if \code{s_i < s_j}.
}
\details{
This measure can either return the test statistic or the p-value from the \code{chisq.test}.
The former is useful for model comparison whereas the latter is useful for determining if a model
is well-calibration. If \code{chisq = FALSE} and \code{m} is the predicted value then you can manually
compute the p.value with \code{pchisq(m, B - 1, lower.tail = FALSE)}.

NOTE: This measure is still experimental both theoretically and in implementation. Results
should therefore only be taken as an indicator of performance and not for
conclusive judgements about model calibration.
}
\section{Dictionary}{

This \link[mlr3:Measure]{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_measures]{mlr_measures} or with the associated sugar function \link[mlr3:mlr_sugar]{msr()}:\preformatted{MeasureSurvDCalibration$new()
mlr_measures$get("surv.dcalib")
msr("surv.dcalib")
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{distr}
}
}

\references{
Haider, Humza, Hoehn, Bret, Davis, Sarah, Greiner, Russell (2020).
\dQuote{Effective Ways to Build and Evaluate Individual Survival Distributions.}
\emph{Journal of Machine Learning Research}, \bold{21}(85), 1--63.
\url{https://jmlr.org/papers/v21/18-772.html}.
}
\seealso{
Other survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_beta}},
\code{\link{mlr_measures_surv.chambless_auc}},
\code{\link{mlr_measures_surv.cindex}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.mae}},
\code{\link{mlr_measures_surv.mse}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.rcll}},
\code{\link{mlr_measures_surv.rmse}},
\code{\link{mlr_measures_surv.schmid}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tnr}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}

Other calibration survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_beta}}

Other distr survival measures: 
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.rcll}},
\code{\link{mlr_measures_surv.schmid}}
}
\concept{calibration survival measures}
\concept{distr survival measures}
\concept{survival measures}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3proba:MeasureSurv]{mlr3proba::MeasureSurv}} -> \code{MeasureSurvDCalibration}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MeasureSurvDCalibration$new()}}
\item \href{#method-clone}{\code{MeasureSurvDCalibration$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate">}\href{../../mlr3/html/Measure.html#method-aggregate}{\code{mlr3::Measure$aggregate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format">}\href{../../mlr3/html/Measure.html#method-format}{\code{mlr3::Measure$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help">}\href{../../mlr3/html/Measure.html#method-help}{\code{mlr3::Measure$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score">}\href{../../mlr3/html/Measure.html#method-score}{\code{mlr3::Measure$score()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3proba" data-topic="MeasureSurv" data-id="print">}\href{../../mlr3proba/html/MeasureSurv.html#method-print}{\code{mlr3proba::MeasureSurv$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvDCalibration$new()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{B}}{(\code{integer(1)}) \cr
Number of buckets to test for uniform predictions over. Default of \code{10} is recommended by
Haider et al. (2020).}

\item{\code{chisq}}{(\code{logical(1)}) \cr
If \code{TRUE} returns the p.value of the corresponding chisq.test instead of the measure.
Otherwise this can be performed manually with \code{pchisq(m, B - 1, lower.tail = FALSE)}.
\code{p > 0.05} indicates well-calibrated.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvDCalibration$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
