% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_spcv_cstf.R
\name{autoplot.ResamplingSptCVCstf}
\alias{autoplot.ResamplingSptCVCstf}
\alias{autoplot.ResamplingRepeatedSptCVCstf}
\alias{plot.ResamplingSptCVCstf}
\alias{plot.ResamplingRepeatedSptCVCstf}
\title{Visualization Functions for SptCV Cstf Methods.}
\usage{
\method{autoplot}{ResamplingSptCVCstf}(
  object,
  task,
  fold_id = NULL,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  repeats_id = NULL,
  tickformat_date = "\%Y-\%m",
  nticks_x = 3,
  nticks_y = 3,
  point_size = 3,
  axis_label_fontsize = 11,
  static_image = FALSE,
  show_omitted = FALSE,
  plot3D = NULL,
  plot_time_var = NULL,
  sample_fold_n = NULL,
  ...
)

\method{autoplot}{ResamplingRepeatedSptCVCstf}(
  object,
  task,
  fold_id = NULL,
  repeats_id = 1,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  tickformat_date = "\%Y-\%m",
  nticks_x = 3,
  nticks_y = 3,
  point_size = 3,
  axis_label_fontsize = 11,
  plot3D = NULL,
  plot_time_var = NULL,
  ...
)

\method{plot}{ResamplingSptCVCstf}(x, ...)

\method{plot}{ResamplingRepeatedSptCVCstf}(x, ...)
}
\arguments{
\item{object}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSptCVCstf} or
\link{ResamplingRepeatedSptCVCstf}.}

\item{task}{\verb{[TaskClassifST]/[TaskRegrST]}\cr
mlr3 task object.}

\item{fold_id}{\verb{[numeric]}\cr
Fold IDs to plot.}

\item{plot_as_grid}{\verb{[logical(1)]}\cr
Should a gridded plot using via \CRANpkg{patchwork} be created? If \code{FALSE}
a list with of \CRANpkg{ggplot2} objects is returned.
Only applies if a numeric vector is passed to argument \code{fold_id}.}

\item{train_color}{\verb{[character(1)]}\cr
The color to use for the training set observations.}

\item{test_color}{\verb{[character(1)]}\cr
The color to use for the test set observations.}

\item{repeats_id}{\verb{[numeric]}\cr
Repetition ID to plot.}

\item{tickformat_date}{\verb{[character]}\cr
Date format for z-axis.}

\item{nticks_x}{\verb{[integer]}\cr
Number of x axis breaks.}

\item{nticks_y}{\verb{[integer]}\cr
Number of y axis breaks.}

\item{point_size}{\verb{[numeric]}\cr
Point size of markers.}

\item{axis_label_fontsize}{\verb{[integer]}\cr
Font size of axis labels.}

\item{static_image}{\verb{[logical]}\cr
Whether to create a static image from the plotly plot via \code{plotly::orca()}.
This requires the \code{orca} utility to be available.
See \url{https://github.com/plotly/orca} for
more information.
When used, by default a file named \code{plot.png} is created in the current
working directory.}

\item{show_omitted}{\verb{[logical]}\cr
Whether to show points not used in train or test set for the current fold.}

\item{plot3D}{\verb{[logical]}\cr
Whether to create a 2D image via \pkg{ggplot2} or a 3D plot via
\pkg{plotly}.}

\item{plot_time_var}{\verb{[character]}\cr
The variable to use for the z-axis (time).
Remove the column role \code{feature} for this variable to only use
it for plotting.}

\item{sample_fold_n}{\verb{[integer]}\cr
Number of points in a random sample stratified over partitions.
This argument aims to keep file sizes of resulting plots reasonable and
reduce overplotting in dense datasets.}

\item{...}{Passed down to \code{plotly::orca()}. Only effective when
\code{static_image = TRUE}.}

\item{x}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSptCVCstf} or
\link{ResamplingRepeatedSptCVCstf}.}
}
\description{
Generic S3 \code{plot()} and \code{autoplot()} (ggplot2) methods to
visualize mlr3 spatiotemporal resampling objects.
}
\details{
This method requires to set argument \code{fold_id}.
No plot showing all folds in one plot can be created.
This is because the LLTO method does not make use of all observations but only
a subset of them (many observations are omitted).
Hence, train and test sets of one fold are not re-used in other folds as in
other methods and plotting these without a train/test indicator would be
misleading.
}
\section{2D vs 3D plotting}{

This method has both a 2D and a 3D plotting method.
The 2D method returns a \pkg{ggplot} with x and y axes representing the spatial
coordinates.
The 3D method uses \pkg{plotly} to create an interactive 3D plot.
Set \code{plot3D = TRUE} to use the 3D method.

Note that spatiotemporal datasets usually suffer from overplotting in 2D
mode.
}

\examples{
\donttest{
if (mlr3misc::require_namespaces(c("sf", "plotly"), quietly = TRUE)) {
  library(mlr3)
  library(mlr3spatiotempcv)
  task_st = tsk("cookfarm_mlr3")
  task_st$set_col_roles("SOURCEID", "space")
  task_st$set_col_roles("Date", "time")
  resampling = rsmp("sptcv_cstf", folds = 5)
  resampling$instantiate(task_st)

  # with both `"space"` and `"time"` column roles set (LLTO), the omitted
  # observations per fold can be shown by setting `show_omitted = TRUE`
  autoplot(resampling, task_st, fold_id = 1, show_omitted = TRUE)
}
}
}
\seealso{
\itemize{
\item mlr3book chapter on \href{https://mlr3book.mlr-org.com/special.html#vis-spt-partitions}{"Spatiotemporal Visualization"}
\item Vignette \href{https://mlr3spatiotempcv.mlr-org.com/articles/spatiotemp-viz.html}{Spatiotemporal Visualization}.
\item \code{\link[=autoplot.ResamplingSpCVBlock]{autoplot.ResamplingSpCVBlock()}}
\item \code{\link[=autoplot.ResamplingSpCVBuffer]{autoplot.ResamplingSpCVBuffer()}}
\item \code{\link[=autoplot.ResamplingSpCVCoords]{autoplot.ResamplingSpCVCoords()}}
\item \code{\link[=autoplot.ResamplingSpCVEnv]{autoplot.ResamplingSpCVEnv()}}
\item \code{\link[=autoplot.ResamplingCV]{autoplot.ResamplingCV()}}
}
}
