% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif_melanoma.R
\name{mlr_tasks_melanoma}
\alias{mlr_tasks_melanoma}
\title{Melanoma Image classification}
\source{
\url{https://huggingface.co/datasets/carsonzhang/ISIC_2020_small}
}
\description{
Classification of melanoma tumor images.
The data is a preprocessed version of the 2020 SIIM-ISIC challenge where
the images have been reshaped to size $(3, 128, 128)$.

By default only the training rows are active in the task,
but the test data (that has no targets) is also included.
Whether an observation is part of the train or test set is indicated by the column \code{"test"}.

There are no labels for the test rows, so by default, these observations are inactive,
which means that the task uses only 32701 of the 43683 observations that are defined in the underlying data backend.

The data backend also contains a more detailed \code{diagnosis} of the specific type of tumor.

Columns:
\itemize{
\item \code{outcome} (factor): the target variable. Whether the tumor is benign or malignant (the positive class)
\item \code{anatom_site_general_challenge} (factor): the location of the tumor on the patient's body
\item \code{sex} (factor): the sex of the patient
\item \code{age_approx} (int): approximate age of the patient at the time of imaging
\item \code{image} (lazy_tensor): The image (shape $(3, 128, 128)$) of the tumor.
ee \code{split} (character): Whether the observation os part of the train or test set.
}
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{tsk("melanoma")
}\if{html}{\out{</div>}}
}

\section{Download}{

The \link[mlr3:Task]{task}'s backend is a \code{\link{DataBackendLazy}} which will download the data once it is requested.
Other meta-data is already available before that.
You can cache these datasets by setting the \code{mlr3torch.cache} option to \code{TRUE} or to a specific path to be used
as the cache directory.
}

\section{Properties}{

\itemize{
\item Task type: \dQuote{classif}
\item Properties: \dQuote{twoclass}, \dQuote{groups}
\item Has Missings: no
\item Target: \dQuote{outcome}
\item Features: \dQuote{sex}, \dQuote{anatom_site_general_challenge}, \dQuote{age_approx}, \dQuote{image}
\item Data Dimension: 43683x11
}
}

\examples{
task = tsk("melanoma")
task
}
\references{
Rotemberg, V., Kurtansky, N., Betz-Stablein, B., Caffery, L., Chousakos, E., Codella, N., Combalia, M., Dusza, S., Guitera, P., Gutman, D., Halpern, A., Helba, B., Kittler, H., Kose, K., Langer, S., Lioprys, K., Malvehy, J., Musthaq, S., Nanda, J., Reiter, O., Shih, G., Stratigos, A., Tschandl, P., Weber, J., Soyer, P. (2021).
\dQuote{A patient-centric dataset of images and metadata for identifying melanomas using clinical context.}
\emph{Scientific Data}, \bold{8}, 34.
\doi{10.1038/s41597-021-00815-z}.
}
