% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorModelTime.R
\name{mlr_terminators_model_time}
\alias{mlr_terminators_model_time}
\alias{TerminatorModelTime}
\title{Terminator that stops after a budget of model evaluation time is depleted}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Terminator}.}
\description{
Class to terminate the tuning after a given model evaluation budget is exceeded.
The terminator measures the used time to train and predict all models contained
in the archive.
}
\section{Construction}{
\preformatted{TerminatorModelTime$new()
term("model_time")
}
}

\section{Parameters}{

\itemize{
\item \code{secs} :: \code{numeric(1)}\cr
Maximum allowed time, in seconds, default is 0.
}
}

\examples{
TerminatorModelTime$new()
term("model_time", secs = 10 * 3600)
}
\seealso{
Other Terminator: 
\code{\link{Terminator}},
\code{\link{mlr_terminators_clock_time}},
\code{\link{mlr_terminators_combo}},
\code{\link{mlr_terminators_evals}},
\code{\link{mlr_terminators_none}},
\code{\link{mlr_terminators_perf_reached}},
\code{\link{mlr_terminators_stagnation}},
\code{\link{mlr_terminators}}
}
\concept{Terminator}
