% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{mlvocab-package}
\alias{mlvocab}
\alias{mlvocab-package}
\title{\code{mlvocab} package}
\description{
The following two-step abstraction is provided by the \code{mlvocab}
package. First, the vocabulary object is built from the entire corpus with
the help of \code{\link[=vocab]{vocab()}}, \code{\link[=update_vocab]{update_vocab()}} and \code{\link[=prune_vocab]{prune_vocab()}}
functions. Second, the vocabulary is passed alongside the corpus to a
variety of corpus pre-processing functions.
}
\details{
Most of the \code{mlvocab} functions accept \code{nbuckets} argument for
partial or full hashing of the corpus.

Current functionality includes:

\itemize{

\item{term index sequences}{\code{\link[=tix_seq]{tix_seq()}} and \code{\link[=tix_mat]{tix_mat()}} produce integer
sequences suitable for direct consumption by various sequence models.}

\item{term matrices}{\code{\link[=dtm]{dtm()}}, \code{\link[=tdm]{tdm()}} and \code{\link[=tcm]{tcm()}} create document-term,
term-document and term-co-occurrence matrices respectively.}

\item{vocabulary embedding}{given pre-trained word-vectors \code{\link[=prune_embeddings]{prune_embeddings()}}
creates smaller embedding matrices treating missing and unknown vocabulary
terms with grace.}

\item{tfidf weighting}{\code{\link[=tfidf]{tfidf()}} computes various versions of term
frequency, inverse document frequency weighting of \code{dtm} and \code{tdm}
matrices.}

}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/vspinu/mlvocab/}
  \item Report bugs at \url{https://github.com/vspinu/mlvocab/issues}
}

}
\author{
Vitalie Spinu (\email{spinuvit@gmail.com})
}
