% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asgn_func.R
\name{asgn_func}
\alias{asgn_func}
\title{ASGN Model Parameter Estimation using MCMC}
\usage{
asgn_func(
  data,
  priors = NULL,
  mcmc = list(nburn = 5000, niter = 10000, thin = 1),
  seed = NULL,
  return_mcmc = FALSE,
  return_summary = FALSE
)
}
\arguments{
\item{data}{A matrix or vector containing the mean methylation levels (M-values)}

\item{priors}{A list of prior parameters for alpha, mu, and sigma2. If NULL, 
weakly informative priors are automatically generated from the data.}

\item{mcmc}{A list of MCMC parameters:
\itemize{
  \item \code{nburn}: Number of burn-in iterations (default: 5000)
  \item \code{niter}: Number of sampling iterations (default: 10000)
  \item \code{thin}: Thinning interval (default: 1)
}}

\item{seed}{Random seed for reproducibility. If NULL, no seed is set.}

\item{return_mcmc}{Logical indicating whether to return full MCMC samples 
for diagnostic purposes (default: FALSE)}

\item{return_summary}{Logical indicating whether to return a summary data.frame
with parameter estimates and 95\% credible intervals (default: FALSE)}
}
\value{
A list that may contain the following elements:
\itemize{
  \item \code{posteriors}: Vector of posterior means for alpha, mu, and sigma2 (always present)
  \item \code{mcmc_samples}: List containing full MCMC chains for alpha, mu, and sigma2 (only if return_mcmc = TRUE)
  \item \code{summary}: Data.frame containing parameter estimates with 95\% credible intervals (only if return_summary = TRUE)
}
}
\description{
Estimates parameters (alpha, mu, sigma2) for the ASGN model using Markov Chain Monte Carlo (MCMC) methods.
This function can be used for both cancer and normal groups in the multi-stage DMR detection framework,
and also as a standalone function for fitting skewed and potentially bimodal data.
}
\details{
This function implements a Metropolis-Hastings within Gibbs sampler to estimate
the parameters of the ASGN distribution, which can model skewed and potentially
bimodal data. The algorithm updates alpha and mu using Metropolis-Hastings steps 
and sigma2 using inverse Gamma sampling.

The ASGN (Alpha-skewed generalized normal) distribution is particularly useful for
modeling methylation data that often exhibits skewness and bimodal issue.
}
\examples{
\donttest{
# Generate sample data
set.seed(2021)
dt <- rgamma(1000, shape = 2, rate = 1)
dt <- as.matrix(dt, ncol=1)

result <- asgn_func(dt, return_mcmc = TRUE, return_summary = TRUE)
print(result$summary)
}

}
\seealso{
\code{\link{mmcmcBayes}} for the main DMR detection function,
\code{\link{traceplot_asgn}} for MCMC diagnostic plots
}
\author{
Zhexuan Yang, Duchwan Ryu, and Feng Luan
}
