% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_funcs.R
\name{sim_reg}
\alias{sim_reg}
\title{Regression Data Simulation for Linear Models}
\usage{
sim_reg(n, p, f2, rho, beta = 0.1)
}
\arguments{
\item{n}{The total number of observations to generate.}

\item{p}{The number of predictors (Beta) in the regression model.}

\item{f2}{The effect size, calculated as (f^2 = R^2 / (1 - R^2)), where
( R^2) is the coefficient of determination.}

\item{rho}{The correlation coefficient between predictors, representing the
off-diagonal elements in the covariance matrix. Should be a numeric
value.}

\item{beta}{The regression coefficients, either a single value replicated for
each predictor or a vector of length equal to the number of predictors (p).}
}
\value{
A list containing two elements: 'y', the simulated response variable,
and 'X', the matrix of predictors.
}
\description{
This function simulates data for linear regression analysis, as described in the
supplemental material of the referenced paper. It generates datasets with a
specified number of predictors and sample size, effect size, and correlation
coefficient, considering a linear model with fixed regression coefficients.
}
\details{
The function validates the length of the beta vector, constructs a
covariance matrix for the predictors, and calculates the variance of the error
term. It then uses the multivariate normal distribution to generate predictor
values and calculates the response variable based on the specified regression
coefficients and effect size.
}
\examples{
# Example usage:
# Simulate data for a regression model with 100 observations, 3 predictors,
# an effect size of 0.10, and a correlation coefficient of 0.5
sim_reg(n = 100, p = 3, f2 = 0.10, rho = 0.5)

}
\references{
Vanbrabant, Leonard; Van De Schoot, Rens; Rosseel, Yves (2015). Constrained
statistical inference: sample-size tables for ANOVA and regression. Frontiers
in Psychology, 5. DOI:10.3389/fpsyg.2014.01565.
URL: https://www.frontiersin.org/articles/10.3389/fpsyg.2014.01565
}
