% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr.R
\name{plotStacked}
\alias{plotStacked}
\title{Stacked plot by Marc Taylor (@marchtaylor on gitHub)}
\usage{
plotStacked(
  x,
  y,
  order.method = "as.is",
  ylab = "",
  xlab = "",
  border = NULL,
  lwd = 1,
  col = rainbow(length(y[1, ])),
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{A vector of values}

\item{y}{A matrix of data series (columns) corresponding to x}

\item{order.method}{Method of ordering y plotting order. One of the 
following: \code{c("as.is", "max", "first")}. \code{"as.is"} - plot in 
order of y column. \code{"max"} - plot in order of when each y series 
reaches maximum value. \code{"first"} - plot in order of when each y series
first value > 0.}

\item{ylab}{y-axis labels}

\item{xlab}{x-axis labels}

\item{border}{Border colors for polygons corresponding to y columns (will recycle) (see ?polygon for details)}

\item{lwd}{Border line width for polygons corresponding to y columns (will recycle)}

\item{col}{Fill colors for polygons corresponding to y columns (will recycle).}

\item{ylim}{y-axis limits. If \code{ylim=NULL}, defaults to \code{c(0, 1.2*max(apply(y,1,sum)}.}

\item{...}{Other plot arguments}
}
\description{
\code{plotStacked} makes a stacked plot where each \code{y} 
series is plotted on top of each other using filled polygons.
}
\keyword{internal}
