% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr_boxplots.R
\name{plot.mob_stats}
\alias{plot.mob_stats}
\title{Plot alpha- and gamma-scale biodiversity statistics for a MoB analysis}
\usage{
\method{plot}{mob_stats}(
  x,
  index = NULL,
  multi_panel = FALSE,
  col = c("#FFB3B5", "#78D3EC", "#6BDABD", "#C5C0FE", "#E2C288", "#F7B0E6", "#AAD28C"),
  cex.axis = 1.2,
  ...
)
}
\arguments{
\item{x}{a \code{mob_stats} object that has the samples and 
treatment level statistics}

\item{index}{The biodiversity statistics that should be plotted.
See \code{\link{get_mob_stats}} for information on the indices. By default there
is one figure for each index, with panels for alpha- and gamma-scale results
as well as for beta-diversity when applicable.}

\item{multi_panel}{A logical variable. If \code{multi_panel = TRUE} then a 
multipanel plot is produced, which shows observed, rarefied, and asymptotic 
species richness and S_PIE at the alpha- and gamma-scale.
This set of variables conveys a comprehensive picture of the underlying 
biodiversity changes.}

\item{col}{a vector of colors for the groups, set to NA if no color is
preferred}

\item{cex.axis}{The magnification to be used for axis annotation relative to
the current setting of cex. Defaults to 1.2.}

\item{...}{additional arguments to provide to \code{boxplot}, \code{points},
and confidence interval functions}
}
\description{
Plots a \code{mob_stats} object which is produced by the 
function \code{get_mob_stats}. The p-value for each statistic
is displayed in the plot title if applicable.
}
\details{
The user may specify which results to plot or simply to plot 
all the results.
}
\examples{
data(inv_comm)
data(inv_plot_attr)
inv_mob_in = make_mob_in(inv_comm, inv_plot_attr)
# without bootstrap CI for gamma-scale
inv_stats = get_mob_stats(inv_mob_in, group_var = "group", n_perm = 20)
plot(inv_stats) 
# with bootstrap CI for gamma-scale
inv_stats_boot = get_mob_stats(inv_mob_in, group_var = "group", n_perm = 20,
                               boot_groups=TRUE)
plot(inv_stats_boot)
}
\author{
Felix May, Xiao Xiao, and Dan McGlinn
}
