% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr.R
\name{plot_abu}
\alias{plot_abu}
\title{Plot distributions of species abundance}
\usage{
plot_abu(
  mob_in,
  group_var,
  ref_level = NULL,
  type = c("sad", "rad"),
  pooled = FALSE,
  col = NULL,
  lwd = 3,
  log = "",
  leg_loc = "topleft"
)
}
\arguments{
\item{mob_in}{a 'mob_in' class object produced by 'make_mob_in'}

\item{group_var}{String that specifies which field in \code{mob_in$env} the
data should be grouped by}

\item{ref_level}{String that defines the reference level of \code{group_var}
to which all other groups are compared with, defaults to \code{NULL}.
If \code{NULL} then the default contrasts of \code{group_var} are used.}

\item{type}{either 'sad' or 'rad' for species abundance vs rank abundance
distribution}

\item{pooled}{Boolean defaults to FALSE which specifies that abundances should
not be pooled at the group level, TRUE specifies that they should be pooled}

\item{col}{optional vector of colors.}

\item{lwd}{a number which specifies the width of the lines}

\item{log}{a string that specifies if any axes are to be log transformed, 
options include 'x', 'y' or 'xy' in which either the x-axis, y-axis, or
both axes are log transformed respectively}

\item{leg_loc}{a string that specifies the location of the legend, 
options include: 'lowerleft', 'topleft', 'loweright','topright'}
}
\description{
Plot distributions of species abundance
}
\examples{
data(inv_comm)
data(inv_plot_attr)
inv_mob_in = make_mob_in(inv_comm, inv_plot_attr, coord_names = c('x', 'y'))
plot_abu(inv_mob_in, 'group', 'uninvaded', type='sad', pooled=FALSE, log='x')
plot_abu(inv_mob_in, 'group', 'uninvaded', type='rad', pooled=TRUE, log='x')
}
