% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{sim_classification}
\alias{sim_classification}
\alias{sim_regression}
\alias{sim_noise}
\title{Simulate datasets}
\usage{
sim_classification(
  num_samples = 100,
  method = "caret",
  intercept = -5,
  num_linear = 10
)

sim_regression(
  num_samples = 100,
  method = "sapp_2014_1",
  std_dev = NULL,
  factors = FALSE
)

sim_noise(
  num_samples,
  num_vars,
  cov_type = "exchangeable",
  outcome = "none",
  num_classes = 2,
  cov_param = 0
)
}
\arguments{
\item{num_samples}{Number of data points to simulate.}

\item{method}{A character string for the simulation method. For
classification, the single current option is "caret". For regression,
values can be "sapp_2014_1", "sapp_2014_2", "van_der_laan_2007_1", or
"van_der_laan_2007_2". See Details below.}

\item{intercept}{The intercept for the linear predictor.}

\item{num_linear}{Number of diminishing linear effects.}

\item{std_dev}{Gaussian distribution standard deviation for residuals.
Default values are shown below in Details.}

\item{factors}{A single logical for whether the binary indicators should be
encoded as factors or not.}

\item{num_vars}{Number of noise predictors to create.}

\item{cov_type}{The multivariate normal correlation structure of the
predictors. Possible values are "exchangeable" and "toeplitz".}

\item{outcome}{A single character string for what type of independent outcome
should be simulated (if any). The default value of "none" produces no extra
columns. Using "classification" will generate a \code{class} column with
\code{num_classes} values, equally distributed. A value of "regression" results
in an \code{outcome} column that contains independent standard normal values.}

\item{num_classes}{When \code{outcome = "classification"}, the number of classes
to simulate.}

\item{cov_param}{A single numeric value for the exchangeable correlation
value or the base of the Toeplitz structure. See Details below.}
}
\description{
These functions can be used to generate simulated data for supervised
(classification and regression) and unsupervised modeling applications.
}
\details{
These functions provide several supervised simulation methods (and one
unsupervised). Learn more by \code{method}:
\subsection{\code{method = "caret"}}{

This is a simulated classification problem with two classes, originally
implemented in \code{\link[caret:twoClassSim]{caret::twoClassSim()}} with all numeric predictors. The
predictors are simulated in different sets. First, two multivariate normal
predictors (denoted here as \code{two_factor_1} and \code{two_factor_2}) are created
with a correlation of about 0.65. They change the log-odds using main
effects and an interaction:

\preformatted{ intercept - 4 * two_factor_1 + 4 * two_factor_2 + 2 * two_factor_1 * two_factor_2 }

The intercept is a parameter for the simulation and can be used to control
the amount of class imbalance.

The second set of effects are linear with coefficients that alternate signs
and have a sequence of values between 2.5 and 0.025. For example, if there
were four predictors in this set, their contribution to the log-odds would
be

\preformatted{ -2.5 * linear_1 + 1.75 * linear_2 -1.00 * linear_3 + 0.25 * linear_4}

(Note that these column names may change based on the value of \code{num_linear}).

The third set is a nonlinear function of a single predictor ranging between
\verb{[0, 1]} called \code{non_linear_1} here:

\preformatted{ (non_linear_1^3) + 2 * exp(-6 * (non_linear_1 - 0.3)^2) }

The fourth set of informative predictors are copied from one of Friedman's
systems and use two more predictors (\code{non_linear_2} and \code{non_linear_3}):

\preformatted{ 2 * sin(non_linear_2 * non_linear_3) }

All of these effects are added up to model the log-odds.
}

\subsection{\code{method = "sapp_2014_1"}}{

This regression simulation is from Sapp et al. (2014). There are 20
independent Gaussian random predictors with mean zero and a variance of 9.
The prediction equation is:

\preformatted{
predictor_01 + sin(predictor_02) + log(abs(predictor_03)) +
 predictor_04^2 + predictor_05 * predictor_06 +
 ifelse(predictor_07 * predictor_08 * predictor_09 < 0, 1, 0) +
 ifelse(predictor_10 > 0, 1, 0) + predictor_11 * ifelse(predictor_11 > 0, 1, 0) +
 sqrt(abs(predictor_12)) + cos(predictor_13) + 2 * predictor_14 + abs(predictor_15) +
 ifelse(predictor_16 < -1, 1, 0) + predictor_17 * ifelse(predictor_17 < -1, 1, 0) -
 2 * predictor_18 - predictor_19 * predictor_20
}

The error is Gaussian with mean zero and variance 9.
}

\subsection{\code{method = "sapp_2014_2"}}{

This regression simulation is also from Sapp et al. (2014). There are 200
independent Gaussian predictors with mean zero and variance 16. The
prediction equation has an intercept of one and identical linear effects of
\code{log(abs(predictor))}.

The error is Gaussian with mean zero and variance 25.
}

\subsection{\code{method = "van_der_laan_2007_1"}}{

This is a regression simulation from van der Laan et al. (2007) with ten
random Bernoulli variables that have a 40\% probability of being a value of
one. The true regression equation is:

\preformatted{
2 * predictor_01 * predictor_10 + 4 * predictor_02 * predictor_07 +
  3 * predictor_04 * predictor_05 - 5 * predictor_06 * predictor_10 +
  3 * predictor_08 * predictor_09 + predictor_01 * predictor_02 * predictor_04 -
  2 * predictor_07 * (1 - predictor_06) * predictor_02 * predictor_09 -
  4 * (1 - predictor_10) * predictor_01 * (1 - predictor_04)
}

The error term is standard normal.
}

\subsection{\code{method = "van_der_laan_2007_2"}}{

This is another regression simulation from van der Laan et al. (2007)  with
twenty Gaussians with mean zero and variance 16. The prediction equation is:

\preformatted{
predictor_01 * predictor_02 + predictor_10^2 - predictor_03 * predictor_17 -
 predictor_15 * predictor_04 + predictor_09 * predictor_05 + predictor_19 -
 predictor_20^2 + predictor_09 * predictor_08
}

The error term is also Gaussian with mean zero and variance 16.
}

\subsection{\code{sim_noise()}}{

This function simulates a number of random normal variables with mean zero.
The values can be independent if \code{cov_param = 0}. Otherwise the values are
multivariate normal with non-diagonal covariance matrices. For
\code{cov_type = "exchangeable"}, the structure has unit variances and covariances
of \code{cov_param}. With \code{cov_type = "toeplitz"}, the covariances have an
exponential pattern (see example below).
}
}
\examples{
set.seed(1)
sim_regression(100)
sim_classification(100)
}
\references{
van der Laan, Mark J., Polley, Eric C and Hubbard, Alan E.. "Super Learner"
\emph{Statistical Applications in Genetics and Molecular Biology}, vol. 6, no. 1,
2007. DOI: 10.2202/1544-6115.1309.

Stephanie Sapp, Mark J. van der Laan & John Canny (2014) Subsemble: an
ensemble method for combining subset-specific algorithm fits, \emph{Journal of
Applied Statistics}, 41:6, 1247-1259, DOI: 10.1080/02664763.2013.864263
}
