% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_model.R
\name{edit_model}
\alias{edit_model}
\title{Edit model within a model grid}
\usage{
edit_model(model_grid, model_name, ...)
}
\arguments{
\item{model_grid}{\code{model_grid}}

\item{model_name}{\code{character}, the unique name (as set by the user) of
the model, that should be modified.}

\item{...}{All the model (and model training) settings you want to modify for
an existing model specification.}
}
\value{
\code{model_grid}
}
\description{
Modify an existing model (and training) specification in a model grid.
}
\examples{
library(magrittr)

# Create model grid and add random forest model.
mg <-
  model_grid() \%>\%
  add_model(model_name = "Random Forest Test", method = "rf", tuneLength = 5)

# Edit the size of tuning grid of the random forest model.
edit_model(mg, model_name = "Random Forest Test", tuneLength = 10)
}
