% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataLoaders.R
\name{DataLoader.CSV}
\alias{DataLoader.CSV}
\title{R6 class representing a cluster LaF csv data loaders}
\description{
R6 class representing a cluster LaF csv data loaders

R6 class representing a cluster LaF csv data loaders
}
\details{
It load batch of data from a set of csv files and
binds them together.
}
\author{
Filippo Monari
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DataLoader.CSV$new()}}
\item \href{#method-..connect..}{\code{DataLoader.CSV$..connect..()}}
\item \href{#method-..get.data..}{\code{DataLoader.CSV$..get.data..()}}
\item \href{#method-feed}{\code{DataLoader.CSV$feed()}}
\item \href{#method-loaders}{\code{DataLoader.CSV$loaders()}}
\item \href{#method-clone}{\code{DataLoader.CSV$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialisation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.CSV$new(loaders)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{loaders}}{a list containing the 'CSVLoader.LaF' objects.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-..connect.."></a>}}
\if{latex}{\out{\hypertarget{method-..connect..}{}}}
\subsection{Method \code{..connect..()}}{
Calls the connect methods of the loadres in order to
open the connections with the csv files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.CSV$..connect..(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{additional argument for the \code{connect}
methods of each loader.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-..get.data.."></a>}}
\if{latex}{\out{\hypertarget{method-..get.data..}{}}}
\subsection{Method \code{..get.data..()}}{
Returns the binded batch of data after applying the
\code{self$process} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.CSV$..get.data..(n, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of rows to draw from each csv file}

\item{\code{...}}{additional arguments for the \code{self$process} function}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-feed"></a>}}
\if{latex}{\out{\hypertarget{method-feed}{}}}
\subsection{Method \code{feed()}}{
Feed a number with the data from the CSV file
Returns X invisibly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.CSV$feed(data = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{list composed by X (containing the features) and Y (containing the targets).
If NULL a the list is created. If provided the numbers in ti will be fed in place.}

\item{\code{...}}{additional arguemnts to be passed to}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-loaders"></a>}}
\if{latex}{\out{\hypertarget{method-loaders}{}}}
\subsection{Method \code{loaders()}}{
Returns a list with the loaders.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.CSV$loaders()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.CSV$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
