% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{.graph}
\alias{.graph}
\title{R6 class representing a computational graph}
\description{
R6 class representing a computational graph

R6 class representing a computational graph
}
\details{
This objects are created by the '.modello' session
object that links them to the corresponding \code{graph}
in the FORTRAN environment.
}
\examples{

## ------------------------------------------------
## Method `.graph$pop`
## ------------------------------------------------

\donttest{
modello.init()
g = graph.open()
graph.close()
g$is.linked() # TRUE
g$pop()
g$is.linked() # FALSE
modello.close()
}

## ------------------------------------------------
## Method `.graph$is.linked`
## ------------------------------------------------

\donttest{
modello.init()
g = graph.open()
graph.close()
g$is.linked() # TRUE
g$pop()
g$is.linked() # FALSE
modello.close()
}

## ------------------------------------------------
## Method `.graph$op`
## ------------------------------------------------

\donttest{
modello.init()
x1 = number(1)
x2 = number(3)
x3 = number(2)
g = graph.open()
y = log((x1 + x3)**x2)
graph.close()
print(y$v)
x1$v = 2
g$op()
print(y$v)
y$dv = 1
g$bw()
print(x1$dv)
print(x2$dv)
print(x3$dv)
modello.close()
}

## ------------------------------------------------
## Method `.graph$bw`
## ------------------------------------------------

\donttest{
modello.init()
x1 = number(1)
x2 = number(3)
x3 = number(2)
g = graph.open()
y = log((x1 + x3)**x2)
graph.close()
print(y$v)
x1$v = 2
g$op()
print(y$v)
y$dv = 1
g$bw()
print(x1$dv)
print(x2$dv)
print(x3$dv)
modello.close()
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{.graph$new()}}
\item \href{#method-finalize}{\code{.graph$finalize()}}
\item \href{#method-name}{\code{.graph$name()}}
\item \href{#method-id}{\code{.graph$id()}}
\item \href{#method-pop}{\code{.graph$pop()}}
\item \href{#method-is.linked}{\code{.graph$is.linked()}}
\item \href{#method-op}{\code{.graph$op()}}
\item \href{#method-bw.zero}{\code{.graph$bw.zero()}}
\item \href{#method-bw}{\code{.graph$bw()}}
\item \href{#method-print}{\code{.graph$print()}}
\item \href{#method-clone}{\code{.graph$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialisation method for reference object of class 'graph'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$new(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{graph} name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Awares if a reference object is remove when
when stil referring to an existing \code{graph}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-name"></a>}}
\if{latex}{\out{\hypertarget{method-name}{}}}
\subsection{Method \code{name()}}{
Returns the \code{graph} name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the \code{graph} name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-id"></a>}}
\if{latex}{\out{\hypertarget{method-id}{}}}
\subsection{Method \code{id()}}{
Returns the \code{graph} id
(i.e. position within the \code{GRAPHS_} array)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$id()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the \code{graph} id
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pop"></a>}}
\if{latex}{\out{\hypertarget{method-pop}{}}}
\subsection{Method \code{pop()}}{
Pop (removes) the \code{graph} from the
\code{GRAPHS_} array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$pop()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init()
g = graph.open()
graph.close()
g$is.linked() # TRUE
g$pop()
g$is.linked() # FALSE
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is.linked"></a>}}
\if{latex}{\out{\hypertarget{method-is.linked}{}}}
\subsection{Method \code{is.linked()}}{
Checks that the reference object is linked to
a \code{graph}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$is.linked()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Retursn TRUE if is linked, FALSE otherwise
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init()
g = graph.open()
graph.close()
g$is.linked() # TRUE
g$pop()
g$is.linked() # FALSE
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-op"></a>}}
\if{latex}{\out{\hypertarget{method-op}{}}}
\subsection{Method \code{op()}}{
Applies all the operators for the nodes in the
\code{graph}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$op()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init()
x1 = number(1)
x2 = number(3)
x3 = number(2)
g = graph.open()
y = log((x1 + x3)**x2)
graph.close()
print(y$v)
x1$v = 2
g$op()
print(y$v)
y$dv = 1
g$bw()
print(x1$dv)
print(x2$dv)
print(x3$dv)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bw.zero"></a>}}
\if{latex}{\out{\hypertarget{method-bw.zero}{}}}
\subsection{Method \code{bw.zero()}}{
Resest the derivative values for the nodes in the \code{graph}
accoriding to the backward differentiation schema.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$bw.zero()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bw"></a>}}
\if{latex}{\out{\hypertarget{method-bw}{}}}
\subsection{Method \code{bw()}}{
Applies all the backward differentiation operators for
the nodes in the \code{graph}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$bw()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init()
x1 = number(1)
x2 = number(3)
x3 = number(2)
g = graph.open()
y = log((x1 + x3)**x2)
graph.close()
print(y$v)
x1$v = 2
g$op()
print(y$v)
y$dv = 1
g$bw()
print(x1$dv)
print(x2$dv)
print(x3$dv)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints a representation of the \code{graph}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.graph$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
