% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{ger}
\alias{ger}
\title{Genral Vector Outer Product}
\usage{
ger(alpha = NULL, A, B, C = NULL)
}
\arguments{
\item{alpha}{a reference object of class 'number' with rank 0}

\item{A}{a reference object of class 'number' with rank 1}

\item{B}{a reference object of class 'number' with rank 1}

\item{C}{a reference number of class 'number' with rank 2}
}
\value{
Returns a reference object of class 'number'
}
\description{
Calculates:
ans = alpha * A.B**T + C
where alpha is a scalar and A, B, are vectors and C is a matrix.
}
\examples{
modello.init()
alpha = number(1, scalar=TRUE)
A = number(rnorm(3))
B = number(rnorm(3))
C = number(matrix(rnorm(9), 3, 3))
ans1 = ger(alpha, A, B, C)
ans2 = ger(NULL, A, B, C)
ans3 = ger(NULL, A, B, NULL)
print(ans1)
print(ans1$v)
print(ans2)
print(ans2$v)
print(ans3)
print(ans3$v)
modello.close()
}
\author{
Filippo Monari
}
