% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\title{Generate \code{n} bootstrap replicates.}
\usage{
bootstrap(data, n, id = ".id")
}
\arguments{
\item{data}{A data frame}

\item{n}{Number of bootstrap replicates to generate}

\item{id}{Name of variable that gives each model a unique integer id.}
}
\value{
A data frame with \code{n} rows and one column: \code{strap}
}
\description{
Generate \code{n} bootstrap replicates.
}
\examples{
library(purrr)
boot <- bootstrap(mtcars, 100)

models <- map(boot$strap, ~ lm(mpg ~ wt, data = .))
tidied <- map_df(models, broom::tidy, .id = "id")

hist(subset(tidied, term == "wt")$estimate)
hist(subset(tidied, term == "(Intercept)")$estimate)
}
