% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_correlation.R
\name{datasummary_correlation}
\alias{datasummary_correlation}
\title{Generate a correlation table for all numeric variables in your dataset.}
\usage{
datasummary_correlation(
  data,
  output = "default",
  fmt = 2,
  title = NULL,
  notes = NULL
)
}
\arguments{
\item{data}{A data.frame (or tibble)}

\item{output}{filename or object type (character string)
\itemize{
  \item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
  \item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "data.frame", "gt", "kableExtra", "huxtable", "flextable".
  \item Warning: the `output` argument \emph{cannot} be used when customizing tables with external packages. See the 'Details' section below.
}}

\item{fmt}{determines how to format numeric values
\itemize{
  \item integer: the number of digits to keep after the period `format(round(x, fmt), nsmall=fmt)`
  \item character: passed to the `sprintf` function (e.g., '\%.3f' keeps 3 digits with trailing zero). See `?sprintf`
  \item function: returns a formatted character string.
}}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}
}
\description{
Generate a correlation table for all numeric variables in your dataset.
}
