% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-exp_smoothing.R
\name{smooth_fit_impl}
\alias{smooth_fit_impl}
\title{Low-Level Exponential Smoothing function for translating modeltime to forecast}
\usage{
smooth_fit_impl(
  x,
  y,
  period = "auto",
  error = "auto",
  trend = "auto",
  season = "auto",
  damping = NULL,
  alpha = NULL,
  beta = NULL,
  gamma = NULL,
  ...
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{period}{A seasonal frequency. Uses "auto" by default. A character phrase
of "auto" or time-based phrase of "2 weeks" can be used if a date or date-time variable is provided.}

\item{error}{The form of the error term: "auto", "additive", or "multiplicative".
If the error is multiplicative, the data must be non-negative.}

\item{trend}{The form of the trend term: "auto", "additive", "multiplicative" or "none".}

\item{season}{The form of the seasonal term: "auto", "additive", "multiplicative" or "none".}

\item{damping}{Apply damping to a trend: "auto", "damped", or "none".}

\item{alpha}{Value of alpha. If NULL, it is estimated.}

\item{beta}{Value of beta. If NULL, it is estimated.}

\item{gamma}{Value of gamma. If NULL, it is estimated.}

\item{...}{Additional arguments passed to \code{smooth::es}}
}
\description{
Low-Level Exponential Smoothing function for translating modeltime to forecast
}
