% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modsem.R, R/package.R
\docType{package}
\name{modsem}
\alias{modsem}
\title{Interaction between latent variables}
\usage{
modsem(
  modelSyntax = NULL,
  data = NULL,
  method = "dblcent",
  match = FALSE,
  standardizeData = FALSE,
  centerData = FALSE,
  firstLoadingFixed = TRUE,
  centerBefore = NULL,
  centerAfter = NULL,
  residualsProds = NULL,
  residualCovSyntax = NULL,
  constrainedProdMean = NULL,
  constrainedLoadings = NULL,
  constrainedVar = NULL,
  constrainedResCovMethod = NULL,
  qml = FALSE,
  auto.scale = "none",
  auto.center = "none",
  estimator = "ML",
  removeFromParTable = NULL,
  addToParTable = NULL,
  macros = NULL,
  run = TRUE,
  ...
)
}
\arguments{
\item{modelSyntax}{lavaan syntax}

\item{data}{dataframe}

\item{method}{method to use:
"rca" = residual centering approach (passed to lavaan),
"uca" = unconstrained approach (passed to lavaan),
"dblcent" = double centering approach (passed to lavaan),
"pind" = prod ind approach, with no constraints or centering (passed to lavaan),
"lms" = laten model structural equations (passed to nlsem),
"custom" = use parameters specified in the function call (passed to lavaan)}

\item{match}{should the product indicators be created by using the match-strategy}

\item{standardizeData}{should data be scaled before fitting model}

\item{centerData}{should data be centered before fitting model}

\item{firstLoadingFixed}{Sould the first factorloading in the latent prod be fixed to one?}

\item{centerBefore}{should inds in prods be centered before computing prods (overwritten by method, if method != NULL)}

\item{centerAfter}{should ind prods be centered after they have been computed?}

\item{residualsProds}{should ind prods be centered using residuals (overwritten by method, if method != NULL)}

\item{residualCovSyntax}{should syntax for residual covariances be produced (overwritten by method, if method != NULL)}

\item{constrainedProdMean}{should syntax prod mean be produced (overwritten by method, if method != NULL)}

\item{constrainedLoadings}{should syntax for constrained loadings be produced (overwritten by method, if method != NULL)}

\item{constrainedVar}{should syntax for constrained variances be produced (overwritten by method, if method != NULL)}

\item{constrainedResCovMethod}{method for constraining residual covariances}

\item{qml}{should QML be used in LMS (via nlsem)}

\item{auto.scale}{methods which should be scaled automatically (usually not useful)}

\item{auto.center}{methods which should be centered automatically (usually not useful)}

\item{estimator}{estimator to use in lavaan}

\item{removeFromParTable}{rows to remove from partable before sending to lavaan (for advanced users)}

\item{addToParTable}{rows to add to partable before sending to lavaan (for advanced users)}

\item{macros}{macros to replace in the syntax before sending to lavaan}

\item{run}{should the model be estimated}

\item{...}{arguments passed to other functions, e.g,. lavaan}
}
\value{
ModSEM object
}
\description{
modsem is a function for estimating structural equation models with latent product indicators.
It is essentially a facny wrapper for lavaan::sem() (and nlsem::nlsem()) which generates the 
necessary syntax, and variables for the estimation of models with latent product indicators.

The most important function is modsem()
}
\examples{
library(modsem)
m1 <- '
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3

  # Inner model
  Y ~ X + Z + X:Z
'
est1 <- modsem(m1, oneInt)
summary(est1)
}
