% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/generics_lavaan.R,
%   R/generics_modsem_da.R, R/generics_modsem_mplus.R, R/generics_modsem_pi.R
\name{parameter_estimates}
\alias{parameter_estimates}
\alias{parameter_estimates.lavaan}
\alias{parameter_estimates.modsem_da}
\alias{parameter_estimates.modsem_mplus}
\alias{parameter_estimates.modsem_pi}
\title{Extract parameterEstimates from an estimated model}
\usage{
parameter_estimates(object, ...)

\method{parameter_estimates}{lavaan}(object, colon.pi = TRUE, ...)

\method{parameter_estimates}{modsem_da}(object, ...)

\method{parameter_estimates}{modsem_mplus}(object, ...)

\method{parameter_estimates}{modsem_pi}(object, colon.pi = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{\link{modsem_pi}}, \code{\link{modsem_da}}, or \code{\link{modsem_mplus}}}

\item{...}{Additional arguments passed to other functions}

\item{colon.pi}{Should colons (\code{:}) be added to the interaction terms (E.g., `XZ` -> `X:Z`)?}
}
\description{
Extract parameterEstimates from an estimated model
}
\section{Methods (by class)}{
\itemize{
\item \code{parameter_estimates(lavaan)}: Get parameter estimates of a \code{lavaan} object

\item \code{parameter_estimates(modsem_da)}: Get parameter estimates of a \code{\link{modsem_da}} object

\item \code{parameter_estimates(modsem_mplus)}: Get parameter estimates of a \code{\link{modsem_mplus}} object

\item \code{parameter_estimates(modsem_pi)}: Get parameter estimates of a \code{\link{modsem_pi}} object

}}
\examples{
m1 <- '
  # Outer Model
  X =~ x1 + x2 + x3
  Z =~ z1 + z2 + z3
  Y =~ y1 + y2 + y3

  # Inner Model
  Y ~ X + Z + X:Z
'
# Double centering approach
est_dca <- modsem(m1, oneInt)

pars <- parameter_estimates(est_dca) # no correction

# Pretty summary
summarize_partable(pars)

# Only print the data.frame
pars
}
