% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-coercion.R
\name{as.module}
\alias{as.module}
\alias{as.module.character}
\alias{as.module.module}
\title{Coercion for Modules}
\usage{
as.module(x, ...)

\method{as.module}{character}(x, topEncl = baseenv(), reInit = TRUE,
  ..., envir = parent.frame())

\method{as.module}{module}(x, reInit = TRUE, ...)
}
\arguments{
\item{x}{something which can be coerced into a module. \code{character} are
interpreted as file / folder names.}

\item{...}{arguments passed to \link{parse}}

\item{topEncl}{(environment) the root of the local search path. It is tried
to find a good default via \link{autoTopEncl}.}

\item{reInit}{(logical) if a module should be re-initialized}

\item{envir}{(environment) the environment from where \code{module} is
called. Used to determine the top level environment and should not be
supplied by the use.}
}
\description{
Interfaces to and from modules.
}
\examples{
# as.module is used by 'use' so see the vignette for examples:
\dontrun{
vignette("modulesInR", "modules")
}
}
