% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_generation.R
\name{create_unique_layer_node_ids}
\alias{create_unique_layer_node_ids}
\title{Assigns node IDs to the biological identifiers across a graph layer}
\usage{
create_unique_layer_node_ids(identifiers1, identifiers2, layer_name)
}
\arguments{
\item{identifiers1, identifiers2}{Data frames containing the biological identifiers of each
group of the same network layer.}

\item{layer_name}{Name of layer node ids are created for}
}
\value{
Returns an named list. Elements `identifiers1` and `identifiers2` contain the input
data frames with an additional column `node_id`. `all` contains all unique node IDs assigned
across the network layer.
}
\description{
(INTERNAL) This function takes two data frames of (biological) identifiers of nodes. Each data
frame corresponds to the identifiers of the components contained in the single-layer network of
 a sample group.
This function outputs the same data frames, with an added column (`node_id`) that contains node
 IDs which can later be used as `name` parameter for an iGraph graph.
Node IDs begin with the defined `prefix` and an underscore. If a molecule is present in both
groups, the node ID will be the same across the whole layer, allowing to easily combine the
graphs of both groups in `differential_score()` to calculate differential scores of identical
nodes in both sample groups.
The function is used by the high-level wrapper \link[molnet]{generate_individual_graphs} to
create annotations, which uniquely define nodes across the network layer.
}
