% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{get_drug_response_score}
\alias{get_drug_response_score}
\title{Calculate drug response score}
\usage{
get_drug_response_score(differential_graph, drug_targets, interaction_table)
}
\arguments{
\item{differential_graph}{iGraph graph object containing differential scores for all edges.
Output of \code{\link{differential_score}}}

\item{drug_targets}{Named list containing two elements (`target_nodes` and
`drugs_to_target_nodes`). Output of \code{\link{determine_drug_targets}}. `target_nodes` is a
vector containing network node names of the nodes that are targeted by the available drugs.
`drugs_to_target_nodes` is a dictionary-like list that maps drugs to the nodes that they
target.}

\item{interaction_table}{Data frame. Element `interaction_table` of `drug_target_interaction`
created by \code{\link{make_drug_target}}. Contains at least two columns: `drug_name`
containing names of drugs and a column named with an identifier present in the targeted layer.}
}
\value{
Data frame containing drug name and associated differential drug response score
}
\description{
This function takes the differential graph (generated in
\code{\link{differential_score}}), the a drug targets object (containing target node names and
drugs and their targets; generated in \code{\link{determine_drug_targets}}) and the supplied
drug-target interaction table (formatted in \code{\link{make_drug_target}}) to calculate the
differential drug response score. The score is the median of all differential scores of the
edges adjacent to all drug target nodes of a particular drug.
}
\examples{
data(drug_gene_interactions)
drug_target_interaction <- make_drug_target(target_molecules='protein',
interaction_table=drug_gene_interactions, match_on='gene_name')


data(drug_targets_example)
data(differential_score_graph_example)
drug_response_score <- get_drug_response_score(differential_score_graph_example,
drug_targets_example[["targets"]], drug_target_interaction$interaction_table)
}
