% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{metabolite_data}
\alias{metabolite_data}
\title{Metabolomics data}
\format{
\describe{
  \item{group1}{ER+ data}
  \describe{
    \item{data}{raw data, metabolites in columns and samples in rows}
    \item{identifiers}{one column per identifier, rows in the same order as the metabolite order
    in 'data', identifiers: biochemical name, METABOLON ID, Pubchem ID}
    }
  \item{group2}{ER- data}
  \describe{
    \item{data}{see above}
    \item{identifiers}{see above}
    }
}
}
\source{
Terunuma, Atsushi et al. “MYC-driven accumulation of 2-hydroxyglutarate is associated
with breast cancer prognosis.”
The Journal of clinical investigation vol. 124,1 (2014): 398-412. doi:10.1172/JCI71180

\url{https://www.metabolon.com}

Pubchem IDs: \url{https://pubchem.ncbi.nlm.nih.gov}

MetaboAnalyst: \url{https://www.metaboanalyst.ca/faces/upload/ConvertView.xhtml}
}
\usage{
metabolite_data
}
\description{
Metabolomics analysis of breast cancer patients data sampled randomly to generate distributions
similar to those reported e.g. in (Terunuma et al., 2014). The data is stratified by estrogen
receptor (ER) expression status (group1 = ER+, group2 = ER-). Each group is given as a sub-list
containing 'data' (raw data, metabolites in columns and samples in rows) and 'identifiers'
(one column per identifier, rows in the same order as the metabolites order in 'data').
}
\keyword{datasets}
