% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{nso_query}
\alias{nso_query}
\title{Create a PXWeb query object}
\usage{
nso_query(tbl_id, selections = list())
}
\arguments{
\item{tbl_id}{Table identifier, e.g. "DT_NSO_0300_001V2".}

\item{selections}{Named list mapping dimension labels (e.g., Year, Sex)
to desired codes or labels.}
}
\value{
An object of class \code{nso_query}.
}
\description{
Builds a lightweight query object that records a table id and selections.
Use \code{\link[=nso_fetch]{nso_fetch()}} to execute it, or \code{\link[=as_px_query]{as_px_query()}} to inspect the
underlying PXWeb body.
}
\examples{
# Create a query object (does not require network)
q <- nso_query("DT_NSO_0300_001V2", list(Year = "2023", Sex = "Total"))
print(q)
}
