% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mytable.R
\name{mytable2}
\alias{mytable2}
\title{Produce combined table for descriptive statistics}
\usage{
mytable2(formula, data, max.ylev = 5, digits = 2, method = 1,
  show.all = FALSE, exact = FALSE, show.total = FALSE)
}
\arguments{
\item{formula}{An object of class "formula". Left side of ~ must contain two grouping variables in an
additive way(e.g. sex+group~), and the right side of ~ must have
variables in an additive way.}

\item{data}{A data.frame contains data for analysis}

\item{max.ylev}{An integer indicating the maximum number of levels of grouping
variable ('y'). If a colummn have unique values less than max.ylev
it is treated as a categorical variable. Default value is 5.}

\item{digits}{An integer indicating the number of decimal places (round) or
significant digits to be used. Default value is 1.}

\item{method}{An integer indicating methods for continuous variables.
Possible values in methods are
\describe{
   \item{1}{forces analysis as normal-distributed}
   \item{2}{forces analysis as continuous non-normal}
   \item{3}{performs a Shapiro-Wilk test to decide between
           normal or non-normal}
}
Default value is 1.}

\item{show.all}{A logical value indicating whether or not all statistical
values have to be shown in table. Default value is FALSE.}

\item{exact}{A logical value indicating whether or not permit call with approximate
parameter. If true, only exact column name permitted.Default value is FALSE.}

\item{show.total}{A logical value indicating whether or not show total group value.
Default value is FALSE.}
}
\value{
An object of class "cbind.mytable"
}
\description{
Produce table for descriptive statistics by two grouping variables for several variables easily.
Depending on  the nature of these variables, different descriptive statistical
methods were used(t-test, ANOVA,Kruskal-Wallis, chisq, Fisher,...)
}
