% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapTranslate.R
\name{morphomapTranslate}
\alias{morphomapTranslate}
\title{morphomapTranslate}
\usage{
morphomapTranslate(corA, medA, Cx, Cy)
}
\arguments{
\item{corA}{matrix: coordinates of the external outline}

\item{medA}{matrix: coordinates of the internal outline}

\item{Cx}{numeric: new x center coordinate}

\item{Cy}{numeric: new y center coordinate}
}
\value{
cortical new centered coordinates of the external outline

medullar new centered coordinates of the internal outline
}
\description{
Translate a section to a new center defined by the user
}
\examples{
extsec<-morphomapCircle(10,1000)
intsec<-morphomapCircle(8,1000)
plot(extsec,asp=1,type="l",xlim=c(-11,11),ylim=c(-11,11))
points(intsec,type="l")
traSect<-morphomapTranslate(extsec,intsec,1,1)
points(traSect$cortical,type="l",col="red")
points(traSect$medullar,type="l",col="red")
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
