% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapPCA.R
\name{morphomapPCA}
\alias{morphomapPCA}
\title{morphomapPCA}
\usage{
morphomapPCA(
  mpShapeList,
  gamMap = TRUE,
  nrow = 61,
  ncol = 24,
  rem.out = TRUE,
  scaleThick = FALSE,
  fac.out = 1.5,
  method = "equiangular",
  scalePCA = TRUE,
  unwrap = "A"
)
}
\arguments{
\item{mpShapeList}{list: list containing morphomapShape objects}

\item{gamMap}{list: list containing morphomapShape objects}

\item{nrow}{list: list containing morphomapShape objects}

\item{ncol}{list: list containing morphomapShape objects}

\item{rem.out}{list: list containing morphomapShape objects}

\item{scaleThick}{list: list containing morphomapShape objects}

\item{fac.out}{list: list containing morphomapShape objects}

\item{method}{list: list containing morphomapShape objects}

\item{scalePCA}{list: list containing morphomapShape objects}

\item{unwrap}{list: list containing morphomapShape objects}
}
\value{
PCscores PC scores

PCs loadings

Variance Table of the explained Variance by the PCs

meanMap mean morphometric map

CorMaps morphometric maps
}
\description{
Calculate maps of cortical thickness and perform a Principal Component Analysis
}
\examples{
\donttest{
data(Ex_mpShapeList)
PCA<-morphomapPCA(Ex_mpShapeList)
plot(PCA$PCscores)
barplot(PCA$Variance[,2])
}
}
\author{
Antonio Profico
}
