% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDoseResponse.reproData.R
\name{plotDoseResponse.reproData}
\alias{plotDoseResponse.reproData}
\title{Plotting method for \code{reproData} objects}
\usage{
\method{plotDoseResponse}{reproData}(x, xlab = "Concentration",
  ylab = "Nb of offspring / Nb individual-days", main = NULL, ylim = NULL,
  target.time = NULL, style = "generic", log.scale = FALSE,
  remove.someLabels = FALSE, axis = TRUE, addlegend = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{reproData}}

\item{xlab}{a title for the \eqn{x}-axis (optional)}

\item{ylab}{a label for the \eqn{y}-axis}

\item{main}{main title for the plot}

\item{ylim}{Y-axis limits}

\item{target.time}{a numeric value corresponding to some observed time in \code{data}}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{log.scale}{if \code{TRUE}, displays \eqn{x}-axis in log scale}

\item{remove.someLabels}{if \code{TRUE}, removes 3/4 of X-axis labels in
\code{'ggplot'} style to avoid the label overlap}

\item{axis}{if \code{TRUE} displays ticks and label axis}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{plotDoseResponse} S3 method for the \code{reproData}
class. It plots the number of offspring per individual-days as a function of
concentration (for a given target time).
}
\details{
The function plots the observed values of the reproduction rate (number of
reproduction outputs per individual-day) for a given time as a function of
concentration. The 95 \% Poisson confidence interval is added to each reproduction
rate. It is calculated using function \code{\link[epitools]{pois.exact}}
from package \code{epitools}.
As replicates are not pooled in this plot, overlapped points are shifted on
the x-axis to help the visualization of replicates.
}
\note{
When \code{style = "ggplot"}, the function calls function
\code{\link[ggplot2]{ggplot}} and returns an object of class \code{ggplot}.
}
\examples{

library(ggplot2)

# (1) Load the data
data(zinc)
zinc <- reproData(zinc)

# (2) Plot dose-response
plotDoseResponse(zinc)

# (3) Plot dose-response with a ggplot style
plotDoseResponse(zinc, style = "ggplot")

}
\seealso{
\code{\link[epitools]{pois.exact}}
}
\keyword{plot}

