% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_size.R
\name{lt.population_size}
\alias{lt.population_size}
\title{Calculates population size from a mortAAR life table
or numeric values}
\usage{
lt.population_size(x, e0, k = 1.1, t)
}
\arguments{
\item{x}{either an object of class mortaar_life_table or
mortaar_life_table_list or an arbitrary numeric value representing
the number of deaths.}

\item{e0}{numeric. life expectancy at birth in years
(if x is of class mortaar_life_table then e0 can be derived directly
from the life table's ex column).}

\item{k}{numeric. Arbitrary number to cater for
individuals not represented in the number of deaths. Default: 1.1.}

\item{t}{numeric. Time span of usage of cemetery in years.}
}
\value{
A data.frame with the following items:

\itemize{
  \item \bold{D}:  Number of deaths.
  \item \bold{e0}: Life expectancy at birth in years.
  \item \bold{k}:  Correction factor.
  \item \bold{t}: Time span of usage of cemetery in years.
  \item \bold{P}: Population size calculated by the formula
 \eqn{P = D * e0 * k / t}
 }
}
\description{
The estimation of the population size for a given cemetery is
only possible if a stationary population is assumed. In this
case, the number of deaths is simply multiplied with the
life expectancy at birth and divided be the time span in years
the cemetery was in use. Additionally, it is assumed
that an unknown number of individuals
is not represented in the cemetery and, therefore, the
resulting number is multiplied by an arbitrary value k
(\emph{Herrmann et al. 1990}, 311f.).
}
\examples{

schleswig <- life.table(schleswig_ma[c("a", "Dx")])
lt.population_size(schleswig, t = 100)

odagsen <- life.table(list(
"corpus mandibulae" = odagsen_cm[c("a", "Dx")],
 "margo orbitalis" = odagsen_mo[c("a", "Dx")]
 ))
lt.population_size(odagsen, e0 = 30, t = 100)

lt.population_size(x = 111, e0 = 32.2, k = 1.2, t = 100)
}
\references{
\insertRef{herrmann_prahistorische_1990}{mortAAR}
}
