\name{maggregate}
\alias{maggregate}
\title{Aggregate for mosaic}
\usage{
  maggregate(formula, data = parent.frame(), FUN, subset,
    overall = mosaic.par.get("aggregate.overall"),
    format = c("default"), drop = FALSE, multiple = FALSE,
    ...)
}
\arguments{
  \item{formula}{a formula.  Left side provides variable to
  be summarized.  Right side and condition describe
  subsets.  If the left side is empty, right side and
  condition are shifted over as a convenience.}

  \item{data}{a data frame}

  \item{FUN}{a function to apply to each subset}

  \item{subset}{a logical indicating a subset of
  \code{data} to be processed.}

  \item{drop}{a logical indicating whether unused levels
  should be dropped.}

  \item{format,overall}{currently unused}

  \item{multiple}{logical indicating whether FUN returns
  multiple values}

  \item{\dots}{additional arguments passed to \code{FUN}}
}
\value{
  a vector
}
\description{
  Compute function on subsets of a variable in a data
  frame.
}
\examples{
maggregate( cesd ~ sex, HELPrct, FUN=mean )
maggregate( cesd ~ sex & homeless, HELPrct, FUN=mean )
maggregate( cesd ~ sex | homeless, HELPrct, FUN=sd )
}

