% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.test.R
\name{prop_test}
\alias{prop_test}
\title{Internal function for testing proportion}
\usage{
prop_test(x, n, p = NULL, alternative = c("two.sided", "less",
  "greater"), conf.level = 0.95, ...)
}
\arguments{
\item{x}{a vector, count, or formula.}

\item{n}{a vector of counts of trials (not needed when \code{x} is a table or matrix).}

\item{p}{a vector of probabilities of success (for the null hypothesis).
The length must be the same as the number of groups specified by \code{x}.}

\item{alternative}{a character string specifying the alternative
    hypothesis, must be one of \code{"two.sided"} (default),
    \code{"greater"} or \code{"less"}.  You can specify just the initial
    letter.  Only used for testing the null that a single proportion
    equals a given value, or that two proportions are equal; ignored
    otherwise.}

\item{conf.level}{confidence level of the returned confidence
    interval.  Must be a single number between 0 and 1.  Only used
    when testing the null that a single proportion equals a given
    value, or that two proportions are equal; ignored otherwise.}

\item{...}{additional arguments passed to methods.}
}
\description{
This function is wrapped by \code{\link[=prop.test]{prop.test()}}, which most users should use instead.
}
