#' Characteristics of various internal combustion engines
#'
#' Internal combustion engines have been built for a variety of purposes
#' ranging from propelling small model airplanes to powering trucks to driving
#' the propellers of giant ships.  This data frame gives the characteristics
#' of a wide size range of such engines.
#'
#' @docType data
#' @name Engines
#' @usage data(Engines)
#'
#' @keywords datasets
#'
#' @format  A data frame with 39 cases, each of which is an internal combustion engine, with observations on the following variables.
#' - `mass` In pounds
#' - `ncylinder` Number of cylinders
#' - `stroke` The length  of the stroke made by a piston
#' - `strokes` Whether the engine cycle is 2-stroke or 4-stroke.
#' - `displacement` In cc
#' - `bore` Diameter of the piston
#' - `BHP` The power generated by  the engine. One BHP is the same as 745.7 Watts.
#' - `RPM` The speed, in revolutions per second, at which the engine generates the listed BHP.
#'   
#'
#' @source McMahon, Thomas A., and John Tyler Bonner. On Size and Life. New York: Scientific American Library, 1983. pp. 60-61
"Engines"
