% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BirthsDoc.R
\docType{data}
\name{Births2015}
\alias{Births2015}
\title{US Births in 2015}
\format{
A data.frame with 365 observations on the following 8 variables.
\itemize{
\item \code{date}   Date
\item \code{births} Number of births on \code{date} (integer)
\item \code{wday}   Day of week (ordered factor)
\item \code{year}   Year (integer)
\item \code{month}  Month (integer)
\item \code{day_of_year}  Day of year (integer)
\item \code{day_of_month} Day of month (integer)
\item \code{day_of_week}  Day of week (integer)
}
}
\source{
Obtained from the National Center for Health Statistics,
National Vital Statistics System,
Natality, 2015 data.
}
\usage{
data(Births2015)
}
\description{
A day by day record of the number of births in the United States in 2015.
}
\examples{
data(Births2015)
if (require(ggformula)) {
  gf_point(births ~ date, data = Births2015)
  gf_point(births ~ date, data = Births2015, color = ~ wday)
}
if (require(dplyr)) {
  Births78 \%>\% 
    group_by(wday) \%>\% summarise(births = sum(births)) \%>\% 
    ungroup() \%>\% mutate(frac = births / sum(births))
  Births2015 \%>\% 
    group_by(wday) \%>\% summarise(births = sum(births)) \%>\% 
    ungroup() \%>\% mutate(frac = births / sum(births))
}
}
\seealso{
\code{\link{Births78}}, \code{\link{Births}}
}
