% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective.R
\name{makeBaselineObjective}
\alias{makeBaselineObjective}
\title{Create mlrMBO Objective Function}
\usage{
makeBaselineObjective(
  learner,
  task,
  filters,
  ps,
  resampling,
  measure = NULL,
  num.explicit.featsel = 0,
  holdout.data = NULL,
  worst.measure = NULL,
  cpo = NULLCPO,
  numfeats = getTaskNFeats(task)
)
}
\arguments{
\item{learner}{\verb{[Learner]} the base learner to use.}

\item{task}{\verb{[Task]} the task to optimize.}

\item{filters}{\verb{[character]} filter values to evaluate and use.}

\item{ps}{\verb{[ParamSet]} the ParamSet of the learner to evaluate. Should
not include \code{selector.selection} etc., only parameters of the actual
learner.}

\item{resampling}{\verb{[ResampleDesc | ResampleInstance]} the resampling strategy to use.}

\item{measure}{\verb{[Measure]} the measure to evaluate.
If measure needs to be maximized, the measure is multiplied by -1,
to make it a minimization task.}

\item{num.explicit.featsel}{\verb{[integer(1)]} additional number of parameters
to add for explicit feature selection.}

\item{holdout.data}{\verb{[Task | NULL]} the holdout data to consider.}

\item{worst.measure}{\verb{[numeric(1)]} worst value to impute for failed evals.}

\item{cpo}{\verb{[CPO]} CPO pipeline to apply before feature selection.}

\item{numfeats}{\verb{[integer(1)]} number of features to consider. Is extracted
from the \code{task} but should be given if \code{cpo} changes the number of features.}
}
\value{
\code{function} that can be used for mlrMBO; irace possibly needs some
adjustments.
}
\description{
"Baseline" performance measure: Creates an objective function that performs
normal parameter optimization by evaluating filters with additional parameters:
\code{mosmafs.nselect} (how many features to select),
\code{mosmafs.iselect} (vector integer parameter that selects explicit features
that are not necessary the best according to filter values)
and \code{mosmafs.select.weights} (numeric parameter vector that does
weighting between filter values to use.
}
