% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.anc.R
\name{make.anc}
\alias{make.anc}
\title{Create design matrix (internal function)}
\usage{
make.anc(y, x, data = NULL, common.mean = FALSE)
}
\arguments{
\item{y}{The response variable - typically a continuous trait.}

\item{x}{The explanatory (discrete) variable used to define the hypothesised rate categories. Can be specified as a column number or column name.}

\item{data}{A data frame containing (minimally) the x and y variables as columns with species names as rownames.}

\item{common.mean}{a logical specififying whether each rate category should have its own mean (\code{common.mean=FALSE}) or all categories should have the same mean (\code{common.mean=FALSE}). See Thomas et al. (2009) for a discussion on the impact of assumptions about mean on rate estimates..}
}
\value{
A design matrix
}
\description{
This is an internal function to generate the design matrix required to define different means for each hypothesised rate category.
}
\references{
Thomas GH, Freckleton RP, & Szekely T. 2006. Comparative analyses of the influence of developmental mode on phenotypic diversification rates in shorebirds. Proceedings of the Royal Society B 273, 1619-1624.
Thomas GH, Meiri S, & Phillimore AB. 2009. Body size diversification in Anolis: novel environments and island effects. Evolution 63, 2017-2030.
}
\author{
Gavin Thomas
}
