% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\docType{data}
\name{mt_id}
\alias{mt_id}
\title{Trial identifier for mousetrap data.}
\format{An object of class \code{character} of length 1.}
\usage{
mt_id
}
\description{
A character string specifying the name of the column containing the ID of 
every trial. By default, this label is called \code{mt_id}. This ID is 
generated when importing data using one of the mt_import functions (e.g., 
\link{mt_import_mousetrap}). Every data.frame that is added to a mousetrap 
data object (see \link{mt_example}) contains a column of that name. In every
trajectory array, the first dimension corresponding to the different trials
has the respective label of the trial as name. Using the \code{mt_id}
variable, data from different data.frames or arrays can be merged easily.
}
\examples{
# the default value
mt_id <- "mt_id"

# Calculate mouse-tracking measures
mt_example <- mt_calculate_measures(mt_example)

# Merge measures with trial data (adding "_raw"
# to columns already existing in the trial data)
mt_example_results <- merge(
  mt_example$data, mt_example$measures,
  by="mt_id",suffixes=c("_raw",""))

}
\keyword{datasets}

