% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{mt_subset}
\alias{mt_subset}
\title{Filter mousetrap data.}
\usage{
mt_subset(data, subset, check = "data")
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details).}

\item{subset}{a logical expression (passed on to \link{subset}) indicating
the rows to keep. Missing values are taken as \code{FALSE}.}

\item{check}{a character string specifying which data should be used for
checking the subset condition.}
}
\value{
A mousetrap data object (see \link{mt_example}) with filtered
  data and trajectories.
}
\description{
Return a subset of the mousetrap data including only the trial data and
corresponding trajectories that meet the conditions specified in the
arguments.
}
\details{
\code{mt_subset} is helpful when trials should be removed from all analyses.
By default, \code{check} is set to "data" meaning that the subset condition
is evaluated based on the trial data (stored in \code{data[["data"]]}).
However, it might also be of interest to only include trials based on
specific mouse-tracking measures (e.g., all trials with an \code{MAD} smaller
than 200). In this case, \code{check} needs to be set to the respective name
of the data.frame (e.g., "measures").

Note that if specific trials should be removed from all analyses based on a
condition known a priori (e.g., practice trials), it is more efficient to use
the \link{subset} function on the raw data before importing the trajectories
using one of the mt_import functions (such as \link{mt_import_mousetrap}).

Besides, if trials should only be removed from some analyses or for specific
plots, note that other mousetrap functions (e.g., \link{mt_reshape},
\link{mt_aggregate}, and \link{mt_plot}) also allow for subsetting.
}
\examples{
# Subset based on trial data
mt_example_atypical <- mt_subset(mt_example, Condition=="Atypical")

# Subset based on mouse-tracking measure (MAD)
mt_example <- mt_measures(mt_example)
mt_example_mad_sub <- mt_subset(mt_example, MAD<400, check="measures")

}
\seealso{
\link{subset} for the R base subset function for vectors, matrices,
or data.frames.

\link{mt_reshape} for information about the subset argument in various other
mousetrap functions.
}
\author{
Pascal J. Kieslich (\email{kieslich@psychologie.uni-mannheim.de})

Felix Henninger
}
