% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{moveplot2}
\alias{moveplot2}
\title{Move plot 2}
\usage{
moveplot2(
  bp,
  time.var,
  group.var,
  move = TRUE,
  hulls = TRUE,
  scale.var = 5,
  align.time = NA,
  reflect = NA
)
}
\arguments{
\item{bp}{biplot object from biplotEZ}

\item{time.var}{time variable}

\item{group.var}{group variable}

\item{move}{whether to animate (TRUE) or facet (FALSE) samples and variables, according to time.var}

\item{hulls}{whether to display sample points or convex hulls}

\item{scale.var}{scaling the vectors representing the variables}

\item{align.time}{a vector specifying the levels of time.var for which the biplots should be aligned. Only biplots corresponding to these time points will be used to compute the alignment transformation.}

\item{reflect}{a character vector specifying the axis of reflection to apply at each corresponding time point in align.time. One of FALSE (default), "x" for reflection about the x-axis, "y" for reflection about the y-axis and "xy" for reflection about both axes.}
}
\value{
An animated or a facet of biplots based on the dynamic frame.
}
\description{
Create animated biplot on samples and variables in a biplot
}
\examples{
data(Africa_climate)
bp <- biplotEZ::biplot(Africa_climate, scaled = TRUE) |> biplotEZ::PCA()
\donttest{
if(interactive()) {
bp |> moveplot2(time.var = "Year", group.var = "Region", hulls = TRUE, move = TRUE)}}
}
