% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{settings}
\alias{settings}
\alias{use_multicore}
\alias{use_disk}
\title{moveVis settings}
\usage{
use_multicore(n_cores = NULL, verbose = TRUE)

use_disk(
  frames_to_disk = TRUE,
  dir_frames = paste0(tempdir(), "/moveVis"),
  n_memory_frames = NULL,
  verbose = TRUE
)
}
\arguments{
\item{n_cores}{numeric, optional, number of cores to be used. If not defined, the number of cores will be detected automatically (\code{n-1} cores will be used with \code{n} being the number of cores available).}

\item{verbose}{logical, if \code{TRUE}, messages and progress information are displayed on the console (default).}

\item{frames_to_disk}{logical, whether to use disk space for creating frames or not. If \code{TRUE}, frames will be written to \code{dir_frames}, clearing memory.}

\item{dir_frames}{character, directory where to save frame during frames creating.}

\item{n_memory_frames}{numeric, maximum number of frames allowed to be hold in memory. This number defines after how many frames memory should be cleared by writing frames in memory to disk.}
}
\value{
None. These functions are used for their side effects.
}
\description{
These functions control session-wide settings that can increase processing speeds.
}
\details{
\code{use_multicore} enables multi-core usage of \code{moveVis} by setting the maximum number of cores to be used. This can strongly increase the speed of creating frames.

\code{use_disk} enables the usage of disk space for creating frames. This can prevent memory overload when creating frames for very large animations.

For most tasks, \code{moveVis} is able to use multiple cores to increase computational times through parallelization. By default, multi-core usage is disabled. This function saves the number of cores that \code{moveVis} should use to the global option \code{"moveVis.n_cores"} that can be printed using \code{getOption("moveVis.n_cores")}.

How much memory is needed to create frames depends on the frame resolution (number of pixels) and the number of frames. Depending on how much memory is available it can make sense to allow disk usage and set a maximum number of frames to be hold in memory that won't fill up the available memory completely.

\code{moveVis} uses the \code{parallel} package for parallelization.
}
\examples{
# enable multi-core usage automatically
use_multicore()

# define number of cores manually
use_multicore(n_cores = 2)

# allow disk use with default directory
# and maxiumum of 50 frames in memory
use_disk(frames_to_disk = TRUE, n_memory_frames = 50)

}
