% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_meta.R
\encoding{UTF-8}
\name{run_meta_resampled}
\alias{run_meta_resampled}
\title{Running hierarchical model meta-analyses (with resamples)}
\usage{
run_meta_resampled(
  rv,
  set_target = c("hr", "ctsd"),
  subpop = FALSE,
  random = FALSE,
  max_samples = 100,
  iter_step = 2,
  trace = FALSE,
  .automate_seq = FALSE,
  .only_max_m = FALSE,
  .lists = NULL
)
}
\arguments{
\item{rv}{A list containing outputs, settings and data objects. Must not be NULL.}

\item{set_target}{Character. Research target: \code{"hr"} for home range or \code{"ctsd"} for speed & distance.}

\item{subpop}{Logical. If TRUE, will run meta-analyses with groups. Default is FALSE.}

\item{random}{Logical. If TRUE, samples random subsets of individuals. Default is FALSE.}

\item{max_samples}{Integer. Maximum number of resamples when \code{random = TRUE}. Must be positive. Default is 100.}

\item{iter_step}{Numeric. The size of each iteration step. Default is 2.}

\item{trace}{Logical. If TRUE, prints progress messages. Default is FALSE.}

\item{.automate_seq}{Logical. If TRUE, overwrites sequence automatically to improve plot readability. Default is FALSE.}

\item{.only_max_m}{Logical. If TRUE, will only run the maximum number of individuals. Default is FALSE.}

\item{.lists}{A list containing already created meta inputs. Default is NULL.}
}
\value{
A data frame containing meta-analysis outputs, including estimates, errors, confidence intervals, and group information.
}
\description{
This function performs a meta-analysis on movement tracking data, for mean home range area (AKDE) or continuous-time speed and distance (CTSD) estimates for a sampled population. It leverages the \code{ctmm} R package, specifically the \code{meta()} function, to obtain population-level mean parameters. This function helps to evaluate the significance of results under combination testing.
}
\examples{
if(interactive()) {
run_meta_resampled(rv, set_target = "hr")
}

}
\author{
Inês Silva \email{i.simoes-silva@hzdr.de}
}
