% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateGridPositions.R
\name{generateGridPositions}
\alias{generateGridPositions}
\title{Specify an equally spaced grid of genetic positions}
\usage{
generateGridPositions(spacing)
}
\arguments{
\item{spacing}{The spacing of the genetic positions, in cM.}
}
\value{
A function which can be applied to an object of class \code{mpcrossMapped} by \code{imputeFounders} or \code{computeGenotypeProbabilities}.
}
\description{
Specify an equally spaced grid of genetic positions
}
\details{
Some functions, such as \code{imputeFounders} and \code{computeGenotypeProbabilities}, take in a set of genetic positions as one of the inputs. This function is an easy way to specify an equally spaced grid of positions. 

Note that the return value is itself a function, which is applied internally by \code{imputeFounders} or \code{computeGenotypeProbabilities} to an object of class \code{mpcrossMapped}.
}
\examples{
data(simulatedFourParentData)
#Create object that includes the correct map
mapped <- new("mpcrossMapped", simulatedFourParentData, map = simulatedFourParentMap)
#Estimate IBD genotypes at all the markers, and marker midpoints
imputed <- imputeFounders(mapped, errorProb = 0.02, 
	extraPositions = generateGridPositions(1))
}
