% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finals.R
\name{finals}
\alias{finals}
\alias{finals,mpcross-method}
\alias{finals,geneticData-method}
\title{Genetic data for final lines

Return the genetic data matrix for the final lines

If the \code{mpcross} object contains a single experiment a matrix is returned, with rows corresponding to genotyped lines and columns corresponding to markers. The founding lines of the population are excluded from this matrix. If an \code{mpcross} object contains multiple experiments a list of such matrices is returned, one for each experiment.}
\usage{
finals(object)

\S4method{finals}{mpcross}(object)

\S4method{finals}{geneticData}(object)
}
\arguments{
\item{object}{The \code{mpcross} object from which to extract the genetic data matrix}
}
\value{
An integer matrix with rows corresponding to genotyped lines and columns corresponding to markers.
}
\description{
Genetic data for final lines

Return the genetic data matrix for the final lines

If the \code{mpcross} object contains a single experiment a matrix is returned, with rows corresponding to genotyped lines and columns corresponding to markers. The founding lines of the population are excluded from this matrix. If an \code{mpcross} object contains multiple experiments a list of such matrices is returned, one for each experiment.
}
