% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree-class.R
\name{pedigree-class}
\alias{pedigree-class}
\title{Pedigree class}
\description{
This class describes a pedigree for an experimental design. Although package mpMap2 only allows for the analysis of pedigrees corresponding to multi-parent crosses, this pedigree class can describe arbitrary experimental designs.
}
\section{Slots}{

\describe{
\item{\code{mother}}{The index within the pedigree of the mother of this individual}

\item{\code{father}}{The index within the pedigree of the father of this individual}

\item{\code{lineName}}{The name of this individual}

\item{\code{selfing}}{A value indicating whether analysis of an experiment using this pedigree should assume infinite generations of selfing. A value of \code{"infinite"} indicates infinite generations of selfing, and a value of \code{"finite"} indicates finite generations of selfing.}

\item{\code{warnImproperFunnels}}{A value indicating whether to warn the user about funnels with repeated founders.}
}}

\seealso{
\code{\link[mpMap2]{pedigree-class}}, \code{\link[mpMap2]{simulateMPCross}}, \code{\link[mpMap2]{detailedPedigree-class}}, \code{\link[mpMap2]{rilPedigree}}, \code{\link[mpMap2]{f2Pedigree}}, \code{\link[mpMap2]{fourParentPedigreeRandomFunnels}}, \code{\link[mpMap2]{fourParentPedigreeSingleFunnel}}, \code{\link[mpMap2]{eightParentPedigreeRandomFunnels}}, \code{\link[mpMap2]{eightParentPedigreeSingleFunnel}}, \code{\link[mpMap2]{sixteenParentPedigreeRandomFunnels}}
}
