% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverseChromosomes.R
\name{reverseChromosomes}
\alias{reverseChromosomes}
\title{Reverse the order of the specified chromosomes}
\usage{
reverseChromosomes(mpcrossMapped, chromosomes)
}
\arguments{
\item{mpcrossMapped}{The initial object, for which we want to reverse some of the chromosomes}

\item{chromosomes}{The names of the chromosomes to reverse}
}
\value{
An object of class \code{mpcrossMapped}, with certain chromosomes reversed.
}
\description{
Create a new object, with the specified chromosomes reversed
}
\details{
Create a new object, with the specified chromosomes reversed
}
\examples{
map <- qtl::sim.map()
pedigree <- f2Pedigree(1000)
cross <- simulateMPCross(map = map, pedigree = pedigree, mapFunction = haldane, seed = 1)
mappedCross <- mpcrossMapped(cross = cross, map = map)
reversedX <- reverseChromosomes(mappedCross, "X")
reversedX@map[["X"]]
mappedCross@map[["X"]]
}
