% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{coverage}
\alias{coverage}
\title{Create a coverage chart of the sampling rate}
\usage{
coverage(
  db,
  participant_id,
  sensor = NULL,
  frequency = mpathsenser::freq,
  relative = TRUE,
  offset = "None",
  start_date = NULL,
  end_date = NULL,
  plot = deprecated()
)
}
\arguments{
\item{db}{A valid database connection. Schema must be that as it is created by
\link[mpathsenser]{open_db}.}

\item{participant_id}{A character string of \emph{one} participant ID.}

\item{sensor}{A character vector containing one or multiple sensors. See
\code{\link[mpathsenser]{sensors}} for a list of available sensors. Use \code{NULL} for all
available sensors.}

\item{frequency}{A named numeric vector with sensors as names and the number of expected samples
per hour}

\item{relative}{Show absolute number of measurements or relative to the expected number?
Logical value.}

\item{offset}{Currently not used.}

\item{start_date}{A date (or convertible to a date using \code{\link[base]{as.Date}}) indicating
the earliest date to show. Leave empty for all data. Must be used with \code{end_date}.}

\item{end_date}{A date (or convertible to a date using \code{\link[base]{as.Date}}) indicating
the latest date to show.Leave empty for all data. Must be used with \code{start_date}.}

\item{plot}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Instead of built-in functionality, use
\code{\link[mpathsenser]{plot.coverage}} to plot the output.}
}
\value{
A ggplot of the coverage results if \code{plot} is \code{TRUE} or a tibble containg the
hour, type of measure (i.e. sensor), and (relative) coverage.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Only applicable to non-reactive sensors with 'continuous' sampling
}
\examples{
\dontrun{
fix_json()
unzip()
freq <- c(
  Accelerometer = 720, # Once per 5 seconds. Can have multiple measurements.
  AirQuality = 1,
  AppUsage = 2, # Once every 30 minutes
  Bluetooth = 60, # Once per minute. Can have multiple measurements.
  Gyroscope = 720, # Once per 5 seconds. Can have multiple measurements.
  Light = 360, # Once per 10 seconds
  Location = 60, # Once per 60 seconds
  Memory = 60, # Once per minute
  Noise = 120,
  Pedometer = 1,
  Weather = 1,
  Wifi = 60 # once per minute
)
coverage(
  db = db,
  participant_id = "12345",
  sensor = c("Accelerometer", "Gyroscope"),
  frequency = mpathsenser::freq,
  start_date = "2021-01-01",
  end_date = "2021-05-01"
)
}
}
