% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laguerre.R
\name{laguerre}
\alias{laguerre}
\title{Generalized Laguerre polynomials}
\usage{
laguerre(degree, alpha = 0, indeterminate = "x", normalized = FALSE)
}
\arguments{
\item{degree}{degree of polynomial}

\item{alpha}{generalization constant}

\item{indeterminate}{indeterminate}

\item{normalized}{provide normalized coefficients}
}
\value{
a mpoly object or mpolyList object
}
\description{
Generalized Laguerre polynomials as computed by orthopolynom.
}
\examples{

laguerre(0)
laguerre(1)
laguerre(2)
laguerre(3)
laguerre(4)
laguerre(5)
laguerre(6)

laguerre(2)
laguerre(2, normalized = TRUE)

laguerre(0:5) 
laguerre(0:5, normalized = TRUE)
laguerre(0:5, indeterminate = "t")



# visualize the laguerre polynomials

library(ggplot2); theme_set(theme_classic())
library(tidyr)

s <- seq(-5, 20, length.out = 201)
N <- 5 # number of laguerre polynomials to plot
(lagPolys <- laguerre(0:N))

# see ?bernstein for a better understanding of
# how the code below works

df <- data.frame(s, as.function(lagPolys)(s))
names(df) <- c("x", paste0("L_", 0:N))
mdf <- gather(df, degree, value, -x)
qplot(x, value, data = mdf, geom = "line", color = degree)

qplot(x, value, data = mdf, geom = "line", color = degree) +
  coord_cartesian(ylim = c(-25, 25))


}
\author{
David Kahle calling code from the orthopolynom package
}
\seealso{
\code{\link{glaguerre.polynomials}}, 
  \url{http://en.wikipedia.org/wiki/Laguerre_polynomials}
}

